from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick("handle_top", "floor")
        # Approach handle_top on the floor along x-axis (axis=0)
        robot.primitive_skill.execute_pick(object_name="handle_top", location_name="floor", axis=0)

        # Step 2: execute_pull("drawer_top", "handle_top", "drawer-area")
        # Pull drawer_top using handle_top at drawer-area, approach along x-axis (axis=0)
        robot.primitive_skill.execute_pull(drawer_name="drawer_top", handle_name="handle_top", location_name="drawer-area", axis=0, distance=0.1)

        # Step 3: execute_pick("dice1", "floor")
        # Pick up dice1 from the floor, approach along z-axis (axis=2)
        robot.primitive_skill.execute_pick(object_name="dice1", location_name="floor", axis=2)

        # Step 4: execute_place("dice1", "drawer_top", "drawer-area")
        # Place dice1 into drawer_top at drawer-area, approach along z-axis (axis=2)
        robot.primitive_skill.execute_place(object_name="dice1", drawer_name="drawer_top", location_name="drawer-area", axis=2)

        # Step 5: execute_push("drawer_top", "drawer-area")
        # Push drawer_top closed at drawer-area, approach along x-axis (axis=0)
        robot.primitive_skill.execute_push(drawer_name="drawer_top", location_name="drawer-area", axis=0, distance=0.1)

        # Step 6: execute_go("drawer-area", "ready-pose")
        # Move robot from drawer-area to ready-pose
        robot.primitive_skill.execute_go(from_location="drawer-area", to_location="ready-pose")

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()