from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Drop one dice into any open drawer.
    Follows the required skill sequence and object mapping.
    """

    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to floor
        robot.execute_go("ready-pose", "floor")

        # Step 2: Pick up the handle (handle_top) from the floor (approach along x-axis)
        robot.execute_pick("handle_top", "floor", axis=0)

        # Step 3: Move from floor to drawer-area
        robot.execute_go("floor", "drawer-area")

        # Step 4: Pull the drawer open using the handle (approach along x-axis)
        robot.execute_pull("drawer_top", "handle_top", "drawer-area", axis=0)

        # Step 5: Move from drawer-area back to floor
        robot.execute_go("drawer-area", "floor")

        # Step 6: Pick up the dice (dice1) from the floor (approach along z-axis)
        robot.execute_pick("dice1", "floor", axis=2)

        # Step 7: Move from floor to drawer-area
        robot.execute_go("floor", "drawer-area")

        # Step 8: Place the dice into the open drawer (drawer_top) at drawer-area (approach along z-axis)
        robot.execute_place("dice1", "drawer_top", "drawer-area", axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()