from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Move to the location of the drawer handle (assume "drawer_top_handle" is the handle for the top drawer)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)  # execute_go

        # Step 2: Pick the drawer handle from the floor, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)  # execute_pick

        # Step 3: Pull the drawer open using the handle, approach along x-axis (axis=0), with sufficient distance
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)  # execute_pull

        # Step 4: Move to the location of the trash inside the drawer (assume "trash" is inside "drawer_top")
        robot.execute_movement(Object["trash"], mode=7)  # execute_go

        # Step 5: Pick the trash from inside the drawer, approach along z-axis (axis=2)
        robot.execute_movement(Object["trash"], mode=1, axis=2)  # execute_pick

        # Step 6: Move to ready pose before placing trash in bin
        robot.execute_movement(mode=8)  # go_to_ready_pose

        # Step 7: Place the trash into the bin, approach along z-axis (axis=2)
        robot.execute_movement(Object["trash_bin"], mode=2, axis=2)  # execute_place

        # Step 8: Move to ready pose after placing trash
        robot.execute_movement(mode=8)  # go_to_ready_pose

        # Step 9: Pick the dice from the floor, approach along z-axis (axis=2)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick

        # Step 10: Move to ready pose before placing dice in drawer
        robot.execute_movement(mode=8)  # go_to_ready_pose

        # Step 11: Place the dice into the drawer, approach along z-axis (axis=2)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place

        # Step 12: Move to ready pose at the end
        robot.execute_movement(mode=8)  # go_to_ready_pose

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()