from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # [Frozen Code Start]
        robot.execute_movement(pose0="ready-pose", pose1="floor", mode=7)
        robot.execute_movement(pose0=Object["drawer_top_handle"], mode=1, axis=0)
        robot.execute_movement(pose0="floor", pose1="drawer-area", mode=7)
        robot.execute_movement(pose0=Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        robot.execute_movement(pose0=Object["trash"], mode=1, axis=2)
        # [Frozen Code End]

        # Step 6: Move to ready-pose (go_to_ready_pose)
        robot.execute_movement(mode=8)

        # Step 7: Place trash into trash_bin at ready-pose (axis=2)
        robot.execute_movement(pose0=Object["trash_bin"], mode=2, axis=2)

        # Step 8: Move to ready-pose
        robot.execute_movement(mode=8)

        # Step 9: Pick dice1 at ready-pose (axis=2)
        robot.execute_movement(pose0=Object["dice1"], mode=1, axis=2)

        # Step 10: Move to ready-pose
        robot.execute_movement(mode=8)

        # Step 11: Place dice1 into drawer_top at ready-pose (use drawer_top_place_left, axis=2)
        robot.execute_movement(pose0=Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 12: Move to ready-pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()