from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick the dice (execute_pick, approach along z-axis)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in execute_pick dice1: {e}")

    # Step 2: Pick the drawer handle (execute_pick, approach along x-axis)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick drawer_top_handle: {e}")

    # Step 3: Pull the drawer open using the handle (execute_pull, approach along x-axis, distance=0.1)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_pull drawer_top_handle: {e}")

    # Step 4: Place the dice inside the drawer (execute_place, approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in execute_place dice1 to drawer: {e}")

    # Step 5: Push the drawer closed (execute_push, approach along x-axis, distance=0.1)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in execute_push drawer_top_handle: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()