from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence that fulfils: “Drop one dice into any open drawer.”
    The sequence strictly follows the required skill order specified.
    """

    robot = RobotController()

    # -------------------------------------------------
    # Step-1 : execute_go  (ready-pose → floor)
    # -------------------------------------------------
    robot.execute_movement(mode=7)

    # -------------------------------------------------
    # Step-2 : execute_pick  (pick the drawer handle lying on the floor)
    #           – approach along x-axis (axis = 0)
    # -------------------------------------------------
    robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

    # -------------------------------------------------
    # Step-3 : execute_pull  (pull the top drawer open)
    #           – keep same approach direction, give a bit more distance
    # -------------------------------------------------
    robot.execute_movement(
        Object["drawer_top_handle"], mode=4, axis=0, distance=0.10
    )

    # -------------------------------------------------
    # Step-4 : execute_pick  (pick the dice from the floor)
    #           – approach from above (axis = 2)
    # -------------------------------------------------
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # -------------------------------------------------
    # Step-5 : execute_go_ready  (return to ready pose)
    # -------------------------------------------------
    robot.execute_movement(mode=8)

    # -------------------------------------------------
    # Step-6 : execute_place  (place the dice into the open drawer)
    #           – use the left placement pose inside the drawer
    # -------------------------------------------------
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    # -------------------------------------------------
    # Step-7 : execute_go_ready  (final ready pose)
    # -------------------------------------------------
    robot.execute_movement(mode=8)


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()