from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for the task:
      1.  Move from the ready pose to the top-drawer handle.
      2.  Grasp the handle.
      3.  Pull the drawer open.
      4.  Pick the trash inside the drawer.
      5.  Return to the ready pose (clears the ‘need-ready’ flag).
      6.  Place the trash in the bin.
      7.  Return to the ready pose.
      8.  Move to the dice location.
      9.  Pick the dice.
     10.  Return to the ready pose.
     11.  Place the dice in the open drawer.
     12.  Push the drawer closed.
     13.  Return to the ready pose (final state).
    """

    robot = RobotController()

    # ------------------------------------------------------------------
    # 1) ready-pose  →  handle_top_location  (execute_go)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["drawer_top_handle"], mode=7)

    # ------------------------------------------------------------------
    # 2) Pick the drawer handle  (execute_pick)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

    # ------------------------------------------------------------------
    # 3) Pull the drawer open  (execute_pull)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.10)

    # ------------------------------------------------------------------
    # 4) Pick the trash from the opened drawer  (execute_pick)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["trash"], mode=1, axis=2)

    # ------------------------------------------------------------------
    # 5) Go to the ready pose to clear ‘need-ready’  (execute_go_ready)
    # ------------------------------------------------------------------
    robot.execute_movement(mode=8)

    # ------------------------------------------------------------------
    # 6) Place the trash into the bin  (execute_place)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["trash_bin"], mode=2, axis=2)

    # ------------------------------------------------------------------
    # 7) Return to the ready pose  (execute_go_ready)
    # ------------------------------------------------------------------
    robot.execute_movement(mode=8)

    # ------------------------------------------------------------------
    # 8) Move to the dice location  (execute_go)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["dice1"], mode=7)

    # ------------------------------------------------------------------
    # 9) Pick the dice  (execute_pick)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # ------------------------------------------------------------------
    # 10) Ready pose again to clear ‘need-ready’  (execute_go_ready)
    # ------------------------------------------------------------------
    robot.execute_movement(mode=8)

    # ------------------------------------------------------------------
    # 11) Place the dice inside the drawer  (execute_place)
    #     (drawer is still open)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    # ------------------------------------------------------------------
    # 12) Push the drawer closed  (execute_push)
    # ------------------------------------------------------------------
    robot.execute_movement(Object["drawer_top_handle"], mode=3, axis=0, distance=0.10)

    # ------------------------------------------------------------------
    # 13) Final return to ready pose  (execute_go_ready)
    # ------------------------------------------------------------------
    robot.execute_movement(mode=8)


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()