from Object_list import Object
from skill_mapping import RobotController


def Long_horizon_task2_oracle_seq():
    """
    Oracle plan that drops one dice into the open drawer by invoking only the
    predefined primitive skills exactly in the order required by the
    specification.
    """

    robot = RobotController()

    try:
        # ------------------------------------------------------------
        # 1) execute_go : ready-pose  → floor  (near the handle)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # ------------------------------------------------------------
        # 2) execute_pick : grasp the handle on the floor
        #    (approach along the x-axis → axis = 0)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # ------------------------------------------------------------
        # 3) execute_go : floor → drawer-area
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)

        # ------------------------------------------------------------
        # 4) execute_pull : pull the top drawer open with the handle
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_top_handle"], mode=4, distance=0.10)

        # ------------------------------------------------------------
        # 5) execute_go : drawer-area → floor  (move to the dice)
        # ------------------------------------------------------------
        robot.execute_movement(Object["dice1"], mode=7)

        # ------------------------------------------------------------
        # 6) execute_pick : pick up the dice (top-down grasp → axis = 2)
        # ------------------------------------------------------------
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # ------------------------------------------------------------
        # 7) execute_go : floor → drawer-area  (return to the open drawer)
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)

        # ------------------------------------------------------------
        # 8) execute_place : place the dice inside the drawer
        # ------------------------------------------------------------
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Optional – explicitly open the gripper after placing
        robot.execute_movement(mode=9)

        # ------------------------------------------------------------
        # 9) execute_go : drawer-area → ready-pose  (finish task)
        # ------------------------------------------------------------
        robot.execute_movement(mode=8)

    except Exception as e:
        # Basic exception handling – can be expanded as needed.
        print(f"[Long_horizon_task2_oracle_seq] Exception occurred: {e}")


def main():
    Long_horizon_task2_oracle_seq()


if __name__ == "__main__":
    main()