"""Module to store a dice inside the drawer using robot skills."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to store a dice inside the drawer."""
    robot = RobotController()

    # Step 1: Pick up the handle (handle_top) from the floor
    robot.execute_movement(Object["handle_top"], mode=1, axis=0)

    # Step 2: Pull the drawer open using the handle at drawer-area
    robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)

    # Step 3: Pick up the dice (dice1) from the floor
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Step 4: Place the dice into the drawer at drawer-area
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    # Step 5: Push the drawer closed at drawer-area
    robot.execute_movement(Object["handle_top"], mode=3, axis=0, distance=0.1)

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()