"""Module to place one dice into a drawer using a robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to place one dice into a drawer."""
    robot = RobotController()

    # Step 1: Move from ready-pose to handle_top_location
    try:
        robot.execute_movement(Object["handle_top"], mode=7)  # execute_go
    except Exception as error:
        print(f"Error in Step 1 (go to handle_top): {error}")

    # Step 2: Pick handle_top (approach along x-axis)
    try:
        robot.execute_movement(Object["handle_top"], mode=1, axis=0)  # execute_pick
    except Exception as error:
        print(f"Error in Step 2 (pick handle_top): {error}")

    # Step 3: Pull drawer_top using handle_top (approach along x-axis)
    try:
        robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)  # execute_pull
    except Exception as error:
        print(f"Error in Step 3 (pull drawer): {error}")

    # Step 4: Move from handle_top_location to dice1_location
    try:
        robot.execute_movement(Object["dice1"], mode=7)  # execute_go
    except Exception as error:
        print(f"Error in Step 4 (go to dice1): {error}")

    # Step 5: Pick dice1 (approach along z-axis)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)  # execute_pick
    except Exception as error:
        print(f"Error in Step 5 (pick dice1): {error}")

    # Step 6: Move from dice1_location to drawer_top_area
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)  # execute_go
    except Exception as error:
        print(f"Error in Step 6 (go to drawer_top_area): {error}")

    # Step 7: Place dice1 into drawer (approach along z-axis)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)  # execute_place
    except Exception as error:
        print(f"Error in Step 7 (place dice1 in drawer): {error}")

def main():
    """Main function to execute the dice placement task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()