from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Put a single dice into the drawer."""
    robot = RobotController()

    # Move to floor location
    robot.execute_movement(Object["floor"], mode=7)

    # Pick up dice1 from floor (z-axis approach)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Move to drawer-area
    robot.execute_movement(Object["drawer-area"], mode=7)

    # Pick up handle_top from floor (x-axis approach)
    robot.execute_movement(Object["handle_top"], mode=1, axis=0)

    # Pull drawer open using handle (x-axis approach)
    robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

    # Place dice1 into drawer (z-axis approach)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()