from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert one die (dice1) into a drawer (drawer_top) as per the task specification."""
    robot = RobotController()

    try:
        # Move from ready-pose to floor (where handle_top is located)
        robot.execute_movement(Object["drawer_top_handle"], mode=6)
        robot.execute_movement(pose0=None, pose1=None, mode=7)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # Pick up handle_top from floor (axis=0 for handle)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Move to drawer-area (where drawer_top is located)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # Pull open drawer_top using handle_top (axis=0 for handle)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Move to floor (where dice1 is located)
        robot.execute_movement(Object["dice1"], mode=7)

        # Pick up dice1 from floor (axis=2 for general object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Move to drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # Place dice1 into drawer_top at drawer-area (axis=2 for general object)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Return to ready-pose after task completion
        robot.execute_movement(pose0=None, pose1=None, mode=8)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the long horizon task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()