from object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Store a dice inside the drawer.
    """
    robot = RobotController()

    try:
        # Step 1: Pick up the dice (dice1) from the floor
        # Use axis=2 for general object (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as error:
        print(f"Error in Step 1 (execute_pick dice1): {error}")

    try:
        # Step 2: Open the drawer (drawer_top) if not already open
        # Use axis=0 for pulling handle, set distance for pull
        robot.execute_movement(Object["handle_top"], mode=1, axis=0)
        robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error in Step 2 (execute_pull drawer_top): {error}")

    try:
        # Step 3: Place the dice into the drawer (drawer_top)
        # Use axis=2 for placing object
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error in Step 3 (execute_place dice1 in drawer_top): {error}")

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()