"""Module to drop one dice into any open drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to drop one dice into any open drawer."""
    robot = RobotController()

    # Step 1: Move from ready-pose to floor
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=6)
        robot.execute_movement(mode=7)
    except Exception as error:
        print(f"Error in Step 1 (go ready-pose -> floor): {error}")

    # Step 2: Pick handle_top from floor (axis=0 for handle)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as error:
        print(f"Error in Step 2 (pick handle_top): {error}")

    # Step 3: Move from floor to drawer-area
    try:
        robot.execute_movement(mode=7)
    except Exception as error:
        print(f"Error in Step 3 (go floor -> drawer-area): {error}")

    # Step 4: Pull drawer open using handle (axis=0 for handle, distance=0.1 for full pull)
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as error:
        print(f"Error in Step 4 (pull drawer): {error}")

    # Step 5: Move from drawer-area to floor
    try:
        robot.execute_movement(mode=7)
    except Exception as error:
        print(f"Error in Step 5 (go drawer-area -> floor): {error}")

    # Step 6: Pick dice1 from floor (axis=2 for general object)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=1, axis=2)
    except Exception as error:
        print(f"Error in Step 6 (pick dice1): {error}")

    # Step 7: Move from floor to drawer-area
    try:
        robot.execute_movement(mode=7)
    except Exception as error:
        print(f"Error in Step 7 (go floor -> drawer-area): {error}")

    # Step 8: Place dice1 into drawer_top at drawer-area (axis=2 for general object)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error in Step 8 (place dice1 in drawer): {error}")

def main():
    """Main entry point to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()