"""Module for executing the task: Place one dice into a drawer."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Oracle sequence for: Place one dice into a drawer."""
    robot = RobotController()

    # Step 1: Move to handle location (assume handle_top is at 'handle_top')
    robot.execute_movement(Object["handle_top"], mode=7)

    # Step 2: Pick the handle (approach along x-axis)
    robot.execute_movement(Object["handle_top"], mode=1, axis=0)

    # Step 3: Pull the drawer open using the handle (approach along x-axis)
    robot.execute_movement(Object["handle_top"], mode=4, axis=0, distance=0.1)

    # Step 4: Move to dice1 location (assume dice1 is at 'dice1')
    robot.execute_movement(Object["dice1"], mode=7)

    # Step 5: Pick the dice (approach along z-axis)
    robot.execute_movement(Object["dice1"], mode=1, axis=2)

    # Step 6: Move to drawer place location (assume 'drawer_top_place_left')
    robot.execute_movement(Object["drawer_top_place_left"], mode=7)

    # Step 7: Place the dice into the drawer (approach along z-axis)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    # Step 8: Set need-ready flag and return to ready-pose
    robot.set_need_ready(True)
    robot.execute_movement(Object["ready-pose"], mode=7)
    robot.set_need_ready(False)

def main():
    """Main entry point for the task execution."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()