"""Module for executing the task: Insert one die into a drawer."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Execute the sequence to insert one die into a drawer."""
    robot = RobotController()
    try:
        # Move to floor (simulate pose update if needed)
        robot.execute_movement(Object["drawer_top_handle"], mode=6)
        robot.execute_movement(pose0=None, pose1=None, mode=7)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
        # Pick handle_top from floor (axis=0 for handle)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Move to drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=7)
        # Pull drawer open using handle_top at drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
        # Move to floor to pick dice1
        robot.execute_movement(Object["dice1"], mode=7)
        # Pick dice1 from floor (axis=2 for general object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Move to drawer-area to place dice1
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
        # Place dice1 into drawer_top at drawer-area (axis=2 for general object)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the long horizon task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()