from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """
    Drops one dice into any open drawer.
    Assumes at least one dice is available and at least one drawer is open.
    """
    robot = RobotController()

    # Find an open drawer and a dice
    open_drawer = None
    dice_obj = None

    # Example: Assume Object contains keys for all drawers and dice
    for drawer_key in Object:
        if drawer_key.startswith("drawer") and "open" in drawer_key:
            open_drawer = drawer_key
            break
    if open_drawer is None:
        # Fallback: check for known open drawer
        if "drawer_top" in Object:
            open_drawer = "drawer_top"

    for obj_key in Object:
        if "dice" in obj_key:
            dice_obj = obj_key
            break

    if open_drawer is None or dice_obj is None:
        print("No open drawer or dice found.")
        return

    # Pick up the dice from the floor (assume z-axis)
    robot.execute_movement(Object[dice_obj], mode=1, axis=2)

    # Place the dice into the open drawer (assume z-axis)
    place_key = open_drawer + "_place_left"
    if place_key in Object:
        robot.execute_movement(Object[place_key], mode=2, axis=2)
    else:
        # Fallback: use the drawer object itself
        robot.execute_movement(Object[open_drawer], mode=2, axis=2)

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()