from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Drop one dice into any open drawer."""
    robot = RobotController()
    try:
        # Move from ready-pose to floor
        robot.execute_movement(Object["drawer_top_handle"], mode=6)
        robot.execute_movement(pose0=None, pose1=None, mode=7)
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # Pick handle_top from floor (axis=0 for handle)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # Move from floor to drawer-area
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # Pull drawer open using handle (axis=0 for handle, distance=0.1 for pull)
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)

        # Move from drawer-area to floor
        robot.execute_movement(Object["dice1"], mode=7)

        # Pick dice1 from floor (axis=2 for general object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Move from floor to drawer-area
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)

        # Place dice1 into drawer_top at drawer-area (axis=2 for general object)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main entry point for dropping one dice into any open drawer."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()