from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    # === Oracle Plan Execution for: "Put a single dice into the drawer." ===

    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
    except Exception as e:
        print(f"Error: Step 0 (move to drawer): {e}")

    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error: Step 1 (pick drawer handle): {e}")

    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error: Step 2 (pull open drawer): {e}")

    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error: Step 3 (pick dice): {e}")

    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error: Step 4 (place dice in drawer): {e}")

    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=3, distance=0.1)
    except Exception as e:
        print(f"Warning: Step 5 (push drawer closed): {e}")

    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error: Step 6 (go to ready pose): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()