from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: Move from ready-pose to drawer-area
        # execute_go(ready-pose, drawer-area)
        robot.execute_movement(Object.get("drawer-area", None), mode=7)
    except Exception as e:
        print(f"Error in Step 1 (execute_go ready-pose to drawer-area): {e}")

    try:
        # Step 2: Pick the top drawer handle (x-axis approach)
        # execute_pick(handle_top, drawer-area)
        robot.execute_movement(Object.get("drawer_top_handle", None), mode=1, axis=0)
    except Exception as e:
        print(f"Error in Step 2 (execute_pick drawer_top_handle): {e}")

    try:
        # Step 3: Pull open the top drawer using handle, distance=0.1, x-axis approach
        # execute_pull(drawer_top, handle_top, drawer-area, distance=0.1)
        robot.execute_movement(Object.get("drawer_top_handle", None), mode=4, axis=0, distance=0.1)
    except Exception as e:
        print(f"Error in Step 3 (execute_pull): {e}")

    try:
        # Step 4: Pick dice1 from the floor (z-axis approach)
        # execute_pick(dice1, floor)
        robot.execute_movement(Object.get("dice1", None), mode=1, axis=2)
    except Exception as e:
        print(f"Error in Step 4 (execute_pick dice1): {e}")

    try:
        # Step 5: Place dice1 into the top drawer (z-axis approach)
        # execute_place(dice1, drawer_top, drawer-area)
        # Use drawer_top_place_left as a standard drop-point in top drawer
        robot.execute_movement(Object.get("drawer_top_place_left", None), mode=2, axis=2)
    except Exception as e:
        print(f"Error in Step 5 (execute_place dice1): {e}")

    try:
        # Step 6: Push the drawer closed, distance=0.15, x-axis approach
        # execute_push(drawer_top, drawer-area, distance=0.15)
        robot.execute_movement(Object.get("drawer_top_handle", None), mode=3, axis=0, distance=0.15)
    except Exception as e:
        print(f"Error in Step 6 (execute_push): {e}")

    try:
        # Step 7: Move back to ready-pose from drawer-area
        # execute_go(drawer-area, ready-pose)
        robot.execute_movement(Object.get("ready-pose", None), mode=7)
    except Exception as e:
        print(f"Error in Step 7 (execute_go drawer-area to ready-pose): {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()