from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # === Step 1: Move from ready-pose to drawer-area ===
        # Use execute_go skill (mode=7) to move to drawer-area.
        # As "drawer-area" is a location, but execute_movement expects a pose, use drawer handle for pose reference.
        robot.execute_movement(Object["drawer_top_handle"], mode=7)

        # === Step 2: Pick up handle_top from floor ===
        # Skill: execute_pick; handle: axis=0 (front/x axis).
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)

        # === Step 3: Pull to open the drawer ===
        # Skill: execute_pull (mode=4), axis=0, provide sufficient distance (e.g., 0.10).
        robot.execute_movement(Object["drawer_top_handle"], mode=4, axis=0, distance=0.10)

        # === Step 4: Pick dice1 from floor ===
        # Skill: execute_pick (mode=1); dice: axis=2 (top-down/z axis).
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # === Step 5: Place dice1 into the opened drawer_top ===
        # Use "drawer_top_place_left" as a deposit pose in drawer; execute_place (mode=2), axis=2.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during plan execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()