from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: Pick handle1 in ready-pose.
    # Mapping: handle1 -> Object["drawer_top_handle"] (top drawer handle), location is ready-pose (robot starts here).
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error during execute_pick for handle1 at ready-pose: {e}")

    # Step 2: Place handle1 in drawer1 at ready-pose.
    # Mapping: drawer1 -> top drawer, so place at appropriate location (usually Object["drawer_top_place_left"] or similar).
    # Since no specific place is asked and only a single dice (handle1) should be put, we use left as default.
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for handle1 in drawer1 at ready-pose: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()