from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    
    # Step 1: Pick up the dice at ready-pose.
    # We assume 'drawer_top_handle', 'drawer_middle_handle', 'drawer_bottom_handle', etc. are mapped,
    # but the plan in the specification uses the object 'dice'.
    # Since only handles are listed in the object list, but the observation/init contains handle1, handle2, handle3,
    # and the goal is "store a dice in the open drawer", we should infer that "dice" is physically "handle1" in this scenario.
    # So, we map dice -> "drawer_top_handle", which from the context seems to be the top handle, matching drawer1, which is the open drawer.
    #
    # As such, we use Object["drawer_top_handle"] wherever the plan uses "dice".
    #
    # Axis: For general objects, use z-axis (axis=2).
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice: {e}")

    # Step 2: Place the dice in drawer1 at ready-pose.
    # For place, use axis=2 (consistent with vertical placing, z-axis).
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice: {e}")

def main():
    Long_horizon_task2_oracle_seq()
 
if __name__ == "__main__":
    main()