from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle sequence for: 'Insert one dice into the drawer that is open.'
    Following plan/specification:
        1. execute_pick("handle3", "ready-pose")
        2. execute_place("handle3", "drawer1", "ready-pose")
    """

    robot = RobotController()

    try:
        # Step 1: Pick up handle3 from the ready-pose location (the 'dice' is handle3 in this env)
        # For handles, approach along x-axis (axis=0)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)
    except Exception as e:
        print(f"Error in execute_pick handle3: {e}")

    try:
        # Step 2: Place handle3 into open drawer1 at ready-pose location
        # Specification uses drawer1 and ready-pose; the place mode is mode=2, axis=0 for handle placement (side approach)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=0)
    except Exception as e:
        print(f"Error in execute_place handle3: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()