from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: execute_pick(dice1, <dice_location>)
        # We assume "dice1" is the dice to be placed, and its pick pose is Object["dice1"].
        # Approach along z-axis (axis=2) for picking up dice.
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: execute_place(dice1, <open_drawer>, <drawer_location>)
        # Place dice1 into the open drawer at the canonical place pose.
        # Use Object["drawer_top_place_left"] as the place pose for the open drawer.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()