from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: execute_pick "dice" (assume "dice1" is the dice to be stored)
    try:
        dice_obj = Object.get("dice1", None)
        if dice_obj is None:
            raise KeyError("Object 'dice1' not found in Object_list.")
        robot.execute_movement(dice_obj, mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick for dice1: {e}")

    # Step 2: execute_place "dice" in open drawer (assume "drawer_top_place_left" is the open drawer place)
    try:
        drawer_place = Object.get("drawer_top_place_left", None)
        if drawer_place is None:
            raise KeyError("Object 'drawer_top_place_left' not found in Object_list.")
        robot.execute_movement(drawer_place, mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1: {e}")

    # Optionally, return to ready pose
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error during return to ready pose: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()