from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: execute_pick(dice_object, dice_location)
        # We'll use "dice1" as the dice to move. Assume it's on the floor.
        # For picking a dice, approach axis=2 (z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: execute_place(dice_object, open_drawer, drawer_location)
        # The goal specifies "the drawer that's already open".
        # We'll use "drawer_top_place_left" as the place location for the open drawer.
        # For placing into a drawer, approach axis=2 (z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()