# run_skeleton_task.py (Completed with Exploration Phase for Missing Predicate)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback indicates (drawer-closed drawer1) is missing or needs to be checked.
        # We will attempt to use the available skills to explore the state of drawer1.

        # Assumptions for object names and locations (update as per your environment)
        drawer_name = 'drawer1'
        handle_name = 'handle1'
        robot_location = 'loc_robot'  # Replace with actual robot location key if needed
        drawer_location = 'loc_drawer1'  # Replace with actual drawer location key if needed

        # Try to get positions for navigation
        try:
            robot_pos = positions[robot_location]
            drawer_pos = positions[drawer_location]
            handle_pos = positions[handle_name]
        except Exception as e:
            print("[Exploration] Could not retrieve all required positions from object_positions:", e)
            # Fallback: try to proceed with available info

        # Step 1: Move robot to drawer location if not already there
        try:
            # If robot is not at drawer location, move there
            obs, reward, done = execute_go(
                env,
                task,
                from_location=robot_location,
                to_location=drawer_location,
                max_steps=100
            )
            print("[Exploration] Robot moved to drawer location.")
        except Exception as e:
            print("[Exploration] execute_go failed or not needed:", e)

        # Step 2: Try to pull the drawer to check if it is closed or locked
        # This will help us determine if (drawer-closed drawer1) is true/missing
        try:
            # First, pick the handle if required
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=handle_name,
                location=drawer_location,
                max_steps=100
            )
            print("[Exploration] Picked handle:", handle_name)
        except Exception as e:
            print("[Exploration] execute_pick failed (maybe already holding or not needed):", e)

        try:
            # Now, try to pull the drawer
            obs, reward, done = execute_pull(
                env,
                task,
                drawer_name=drawer_name,
                handle_name=handle_name,
                location=drawer_location,
                max_steps=100
            )
            print("[Exploration] Attempted to pull the drawer to check its state.")
        except Exception as e:
            print("[Exploration] execute_pull failed (drawer may be locked or already open):", e)

        # Step 3: If pull fails, try to push (close) the drawer to ensure (drawer-closed drawer1)
        try:
            obs, reward, done = execute_push(
                env,
                task,
                drawer_name=drawer_name,
                location=drawer_location,
                max_steps=100
            )
            print("[Exploration] Attempted to push (close) the drawer.")
        except Exception as e:
            print("[Exploration] execute_push failed (drawer may already be closed):", e)

        # At this point, we have explored the state of the drawer and attempted to ensure (drawer-closed drawer1)
        # If further exploration is needed (e.g., for lock status), repeat similar steps with other skills

        # === Main Task Plan (Example) ===
        # After exploration, proceed with the main oracle plan as needed.
        # For demonstration, we show a generic pick and place sequence.

        # Example: Pick an object from the floor and place it in the drawer
        object_to_pick = 'object1'  # Replace with actual object name
        object_location = 'loc_object1'  # Replace with actual location key

        try:
            # Move to object location
            obs, reward, done = execute_go(
                env,
                task,
                from_location=drawer_location,
                to_location=object_location,
                max_steps=100
            )
            print("[Task] Robot moved to object location.")
        except Exception as e:
            print("[Task] execute_go to object failed:", e)

        try:
            # Pick the object
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=object_to_pick,
                location=object_location,
                max_steps=100
            )
            print("[Task] Picked object:", object_to_pick)
        except Exception as e:
            print("[Task] execute_pick failed:", e)

        try:
            # Move back to drawer location
            obs, reward, done = execute_go(
                env,
                task,
                from_location=object_location,
                to_location=drawer_location,
                max_steps=100
            )
            print("[Task] Robot returned to drawer location.")
        except Exception as e:
            print("[Task] execute_go to drawer failed:", e)

        try:
            # Place the object in the drawer
            obs, reward, done = execute_place(
                env,
                task,
                object_name=object_to_pick,
                drawer_name=drawer_name,
                location=drawer_location,
                max_steps=100
            )
            print("[Task] Placed object in drawer.")
        except Exception as e:
            print("[Task] execute_place failed:", e)

        # You can add more steps as per your oracle plan

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
