# run_skeleton_task.py (Completed with Exploration Phase for Missing Predicate)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Use only predefined skills

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # === Exploration Phase: Identify Missing Predicate ===
        # Feedback indicates (drawer-closed drawer1) is missing or needs to be explored.
        # We will attempt to use available skills to explore the state of drawer1.

        # Assumptions for object names and locations (replace with actual names if different)
        drawer_name = 'drawer1'
        handle_name = 'handle1'
        robot_location = 'loc_robot'  # Replace with actual robot location key if needed
        drawer_location = 'loc_drawer1'  # Replace with actual drawer location key if needed

        # Try to get actual positions if available
        try:
            drawer_pos = positions[drawer_name]
        except Exception:
            drawer_pos = None
        try:
            handle_pos = positions[handle_name]
        except Exception:
            handle_pos = None

        # Step 1: Move robot to drawer location if not already there
        # (Assume we have a way to get current robot location; if not, just call execute_go)
        try:
            obs, reward, done = execute_go(
                env,
                task,
                from_location=robot_location,
                to_location=drawer_location,
                max_steps=100
            )
            print(f"[Exploration] Robot moved to {drawer_location}")
        except Exception as e:
            print(f"[Exploration] Error moving robot: {e}")

        # Step 2: Try to pick the handle (if handle is present and robot hand is empty)
        try:
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=handle_name,
                location=drawer_location,
                max_steps=100
            )
            print(f"[Exploration] Picked up handle {handle_name}")
        except Exception as e:
            print(f"[Exploration] Error picking handle: {e}")

        # Step 3: Try to pull the drawer to check if it is closed/locked/unlocked
        # This will help us determine the missing predicate (drawer-closed)
        try:
            obs, reward, done = execute_pull(
                env,
                task,
                drawer_name=drawer_name,
                handle_name=handle_name,
                location=drawer_location,
                max_steps=100
            )
            print(f"[Exploration] Pulled drawer {drawer_name} to check state")
        except Exception as e:
            print(f"[Exploration] Error pulling drawer: {e}")

        # Step 4: Check if the drawer is closed (predicate exploration)
        # This would typically be done by checking the environment state or observation
        # For demonstration, print feedback and note that (drawer-closed drawer1) is the missing predicate
        print("[Exploration] Based on feedback, the missing predicate is likely (drawer-closed drawer1)")

        # === End of Exploration Phase ===

        # === Main Task Plan (Example) ===
        # Here you would continue with the oracle plan, using only the available skills.
        # For demonstration, we show a generic sequence (replace with actual plan as needed):

        # Example: Place an object in the drawer if it is open
        object_to_place = 'object1'  # Replace with actual object name
        try:
            # Move to object location
            object_location = 'loc_object1'  # Replace with actual location
            obs, reward, done = execute_go(
                env,
                task,
                from_location=drawer_location,
                to_location=object_location,
                max_steps=100
            )
            print(f"[Task] Moved to {object_location} to pick up {object_to_place}")
        except Exception as e:
            print(f"[Task] Error moving to object: {e}")

        try:
            # Pick the object
            obs, reward, done = execute_pick(
                env,
                task,
                object_name=object_to_place,
                location=object_location,
                max_steps=100
            )
            print(f"[Task] Picked up {object_to_place}")
        except Exception as e:
            print(f"[Task] Error picking object: {e}")

        try:
            # Move back to drawer
            obs, reward, done = execute_go(
                env,
                task,
                from_location=object_location,
                to_location=drawer_location,
                max_steps=100
            )
            print(f"[Task] Returned to {drawer_location} to place {object_to_place}")
        except Exception as e:
            print(f"[Task] Error moving to drawer: {e}")

        try:
            # Place the object in the drawer
            obs, reward, done = execute_place(
                env,
                task,
                object_name=object_to_place,
                drawer_name=drawer_name,
                location=drawer_location,
                max_steps=100
            )
            print(f"[Task] Placed {object_to_place} in {drawer_name}")
        except Exception as e:
            print(f"[Task] Error placing object: {e}")

        # Optionally, close the drawer
        try:
            obs, reward, done = execute_push(
                env,
                task,
                drawer_name=drawer_name,
                location=drawer_location,
                max_steps=100
            )
            print(f"[Task] Closed {drawer_name}")
        except Exception as e:
            print(f"[Task] Error closing drawer: {e}")

        # === End of Main Task Plan ===

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()