"""Module to insert one dice into the open drawer using the robot controller."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to pick up a dice and place it into the open drawer."""
    robot = RobotController()

    # Step 1: Pick up the dice from the floor
    try:
        # Mapping: dice1 -> "dice1", ready-pose -> approach from x-axis (axis=0)
        robot.execute_movement(Object["dice1"], mode=1, axis=0)
    except Exception as error:
        print(f"Error during execute_pick on dice1: {error}")

    # Step 2: Place the dice into the open drawer (drawer1)
    try:
        # Mapping: place dice1 into drawer1 at ready-pose (axis=0 for dice)
        robot.execute_movement(Object["dice1"], mode=2, axis=0)
    except Exception as error:
        print(f"Error during execute_place for dice1 into drawer1: {error}")

def main():
    """Main function to execute the long horizon task sequence."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()