"""Module to place one dice into the open drawer using the robot controller."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to pick up a dice and place it into the open drawer."""
    robot = RobotController()

    # Step 1: Pick up the dice (assume 'dice' is the key in Object and is on the floor at ready-pose)
    robot.execute_movement(Object["dice"], mode=1, axis=0)

    # Step 2: Place the dice into the open drawer (assume 'drawer_top_place_left' is the place pose for the open drawer)
    robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=0)

def main():
    """Main function to execute the dice placement task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()