from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task_store_dice_in_drawer():
    """Store a dice in the open drawer."""
    robot = RobotController()
    try:
        # Step 1: Pick up the dice from the floor at ready-pose
        robot.execute_movement(Object["dice"], mode=1, axis=0)
        # Step 2: Place the dice into the open drawer1 at ready-pose
        robot.execute_movement(Object["drawer_top"], mode=2, axis=0, target_object=Object["dice"])
    except Exception as error:
        print(f"Error during task execution: {error}")

def main():
    """Main function to execute the dice storing task."""
    long_horizon_task_store_dice_in_drawer()

if __name__ == "__main__":
    main()