"""Module to store a dice in the open drawer using robot primitive skills."""

from object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Sequence to pick any dice and place it in the open drawer."""
    robot = RobotController()

    # Find any dice object on the floor
    dice_obj = None
    for obj_name, obj in Object.items():
        if "dice" in obj_name and robot.is_on_floor(obj):
            dice_obj = obj
            break

    if dice_obj is None:
        print("No dice found on the floor.")
        return

    # Find any open drawer
    open_drawer = None
    for obj_name, obj in Object.items():
        if "drawer" in obj_name and robot.is_drawer_open(obj):
            open_drawer = obj
            break

    if open_drawer is None:
        print("No open drawer found.")
        return

    # Move to the dice and pick it up
    robot.execute_pick(dice_obj)

    # Move to the open drawer and place the dice inside
    robot.execute_place(dice_obj, open_drawer)

def main():
    """Main entry point for the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()