"""Module to place one dice into the open drawer."""
from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Place one dice into the open drawer."""
    robot = RobotController()

    # Find any dice on the floor
    dice_candidates = [name for name in Object if name.startswith("dice")]
    dice_to_pick = None
    for dice in dice_candidates:
        if Object[dice].location == "floor":
            dice_to_pick = dice
            break
    if dice_to_pick is None:
        print("No dice found on the floor.")
        return

    # Find an open drawer
    open_drawer = None
    for drawer_name in ["drawer1", "drawer2", "drawer3"]:
        drawer_obj = Object.get(drawer_name)
        if drawer_obj and drawer_obj.state == "open":
            open_drawer = drawer_name
            break
    if open_drawer is None:
        print("No open drawer found.")
        return

    # Pick up the dice
    robot.execute_movement(Object[dice_to_pick], mode=1, axis=2)

    # Place the dice into the open drawer
    # Assume the place location mapping is "drawer_top_place_left" for drawer1, etc.
    place_location = f"{open_drawer}_top_place_left"
    if place_location not in Object:
        print(f"Place location {place_location} not found in Object list.")
        return
    robot.execute_movement(Object[place_location], mode=2, axis=2)

def main():
    """Main entry point to execute the task."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()