"""Module to execute the task: Put a single dice in the already open drawer."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Pick up dice1 and place it in the already open drawer1."""
    robot = RobotController()

    # Move to ready pose if not already there
    robot.execute_movement(Object["drawer_top_handle"], mode=8)

    # Pick up dice1 from the floor at ready-pose
    robot.execute_pick(Object["dice1"], Object["ready-pose"])

    # Move to drawer1 area (if needed)
    robot.execute_movement(Object["drawer_top_handle"], mode=8)

    # Place dice1 into the already open drawer1 at drawer-area
    robot.execute_place(Object["dice1"], Object["drawer1"], Object["drawer-area"])

def main():
    """Main entry point for the task execution."""
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()