"""Module to insert one dice into the open drawer."""

from Object_list import Object
from skill_mapping import RobotController

def long_horizon_task2_oracle_seq():
    """Insert one dice into the drawer that is open."""
    robot = RobotController()

    # Find an open drawer
    open_drawer = None
    for drawer_name in ["drawer1", "drawer2", "drawer3"]:
        if Object[drawer_name].state.get("open", False):
            open_drawer = drawer_name
            break

    if open_drawer is None:
        raise RuntimeError("No open drawer found.")

    # Find a dice object on the floor
    dice_obj = None
    for obj_name in Object:
        if "dice" in obj_name and Object[obj_name].state.get("on_floor", False):
            dice_obj = obj_name
            break

    if dice_obj is None:
        raise RuntimeError("No dice object found on the floor.")

    # Pick up the dice
    robot.execute_pick(Object[dice_obj])

    # Place the dice into the open drawer
    robot.execute_place(Object[dice_obj], Object[open_drawer])

def main():
    long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()