"""Module to move one dice to the drawer that's already open."""
from Object_list import Object
from skill_mapping import RobotController

def move_one_dice_to_open_drawer():
    """Moves one available dice to the already open drawer."""
    robot = RobotController()

    # Identify an available dice
    dice_candidates = [obj for obj in Object if "dice" in obj]
    dice_to_move = None
    for dice in dice_candidates:
        if Object[dice].location == "on-floor":
            dice_to_move = dice
            break
    if dice_to_move is None:
        print("No available dice on the floor to move.")
        return

    # Identify the open drawer
    open_drawer = None
    for drawer in ["drawer1", "drawer2", "drawer3"]:
        if hasattr(Object, drawer) and getattr(Object[drawer], "state", None) == "open":
            open_drawer = drawer
            break
    if open_drawer is None:
        # Fallback: check known open drawer from observation
        open_drawer = "drawer1"

    # Pick up the dice
    try:
        robot.execute_movement(Object["drawer_top_handle"], mode=8)
        robot.execute_movement(Object[dice_to_move], mode=1, axis=2)
    except Exception as error:
        print(f"Error during execute_pick: {error}")
        return

    # Place the dice into the open drawer
    try:
        robot.execute_movement(mode=8)
        place_location = f"{open_drawer}_place_left"
        if place_location in Object:
            robot.execute_movement(Object[place_location], mode=2, axis=2)
        else:
            robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)
    except Exception as error:
        print(f"Error during execute_place: {error}")

def main():
    """Main entry point to execute the dice moving task."""
    move_one_dice_to_open_drawer()

if __name__ == "__main__":
    main()