from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # === Step 1: Pick up a dice (dice1) from its current location, approach along z-axis ===
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error during execute_pick on dice1: {e}")

    # Move to ready pose (optional for clarity between actions)
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error moving to ready pose after picking dice1: {e}")

    # === Step 2: Place dice1 into the open drawer (e.g., drawer_top_place_left), approach along z-axis ===
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during execute_place for dice1 into open drawer: {e}")

    # Move back to ready pose after placement (optional)
    try:
        robot.execute_movement(mode=8)
    except Exception as e:
        print(f"Error moving to ready pose after placing dice1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()