from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle plan to 'Put a single dice in the already open drawer' using only predefined skills.
    Executes the two required skills in sequence as per the provided specification.
    """

    robot = RobotController()

    try:
        # Step 1: Pick up a single dice. We'll choose dice1 for this task.
        # Use axis=2 for a top-down (z-axis) approach for picking.
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Step 2: Place the dice into the already open drawer.
        # Assuming the open drawer's place position is 'drawer_top_place_left'.
        # Use axis=2 for a top-down (z-axis) placing action.
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

    except Exception as e:
        print(f"Error during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()