# run_skeleton_task.py (Completed with Exploration Phase)

import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *  # Predefined skill functions are used directly

from video import init_video_writers, recording_step, recording_get_observation

from object_positions import get_object_positions


def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation, with built-in exploration for missing predicates.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()
        
        # -----------------
        # Required objects/drawers/locations used in task -- these should be consistent with your env
        # Replace keys as appropriate for your setup.
        try:
            drawer1 = 'drawer1'
            handle1 = 'handle1'
            obj_to_pick = 'object1'
            robot_location = 'loc_start'
            drawer_location = 'loc_drawer'
        except Exception as e:
            print("[Setup] Could not find object references in positions:", str(e))
            return

        # (You may need to update the names above based on how your env/object_positions labels entities.)

        # -------------- Exploration Phase: Identify Missing Predicate --------------
        # Feedback: (drawer-unlocked drawer1) missing; must discover lock status.
        # Hypothesis: lock-known predicate for drawer is missing and needed for downstream execution.
        # Use the skill(s) that enable lock-known acquisition.
        # In our exploration domain, this is done via execute_pull (called on a handle of the drawer, when the lock-known predicate is false).

        # The real mapping will depend on your task's initial state and object names.
        # For illustration, let's assume: handle1 is associated with drawer1, both at loc_drawer.

        print("[Exploration] Checking if lock status of", drawer1, "is known...")

        # This explore/predicate acquisition phase is added per instructions.
        # Try to pull the handle to learn the lock status (may fail if not allowed yet).
        try:
            # Attempt to execute_pull to gain knowledge about drawer lock (per exploration knowledge)
            # If you have a special 'explore_pull' skill for exploration, use it. Otherwise, use available ones.
            obs, reward, done = execute_pull(env, task, drawer1, handle1, drawer_location)
            print("[Exploration] Executed execute_pull for lock discovery on", drawer1)
        except Exception as e:
            # If failed, log and continue (could already be known, or action not applicable)
            print("[Exploration] Could not execute execute_pull for lock-known predicate:", str(e))

        # At this point, in a real pipeline, the knowledge about lock/unlock of drawer1 should be available ("lock-known (drawer1)").
        # In a higher-level loop, you would check predicate state here.
        # For demonstration, we continue.

        # ----------------- Task Skill Execution (Oracle Plan) -----------------
        # Now perform regular task actions: move, pick, place, push/pull drawer, etc.

        # EXAMPLE PLAN (replace with actual oracle plan as needed)
        # 1. Move to drawer location
        try:
            print("[Task] Moving robot to drawer location:", drawer_location)
            obs, reward, done = execute_go(env, task, robot_location, drawer_location)
            robot_location = drawer_location
        except Exception as e:
            print("[Task] Error moving to drawer location:", str(e))

        # 2. Open the drawer (execute_pull; requires holding the handle, drawer is unlocked and closed)
        try:
            print("[Task] Picking handle:", handle1)
            obs, reward, done = execute_pick(env, task, handle1, drawer_location)
        except Exception as e:
            print("[Task] Error picking handle:", str(e))

        try:
            print("[Task] Pulling the drawer to open:", drawer1)
            obs, reward, done = execute_pull(env, task, drawer1, handle1, drawer_location)
        except Exception as e:
            print("[Task] Error pulling/opening drawer:", str(e))

        # 3. Pick the object to be placed (on floor, at robot location)
        try:
            print("[Task] Picking up object:", obj_to_pick)
            obs, reward, done = execute_pick(env, task, obj_to_pick, robot_location)
        except Exception as e:
            print("[Task] Error picking object:", str(e))

        # 4. Place object inside drawer (which is now open)
        try:
            print("[Task] Placing object in drawer:", obj_to_pick, "->", drawer1)
            obs, reward, done = execute_place(env, task, obj_to_pick, drawer1, robot_location)
        except Exception as e:
            print("[Task] Error placing object in drawer:", str(e))

        # 5. Push drawer closed
        try:
            print("[Task] Pushing drawer to close:", drawer1)
            obs, reward, done = execute_push(env, task, drawer1, robot_location)
        except Exception as e:
            print("[Task] Error pushing/closing drawer:", str(e))

        # ---------------------------- END OF PLAN ----------------------------

        print("[Task] Oracle plan execution complete.")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()
