from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the oracle plan for:
        Goal: Place two dice (actually two handles to be placed) into the open drawer.
    The sequence follows the given specification with required skills:
        execute_pick
        execute_place
    and step-by-step parameters.
    """
    robot = RobotController()

    try:
        # Step 1: execute_pick(handle3, ready-pose)
        #   - handle3 → "drawer_bottom_handle"
        #   - location "ready-pose": not mapped to an object pose, so no explicit position needed, axis=0 (handle: x-axis)
        robot.execute_movement(Object["drawer_bottom_handle"], mode=1, axis=0)

        # Step 2: execute_place(handle3, drawer1, ready-pose)
        #   - Place into open drawer (drawer1) at "ready-pose", axis=2 (into drawer: z-axis)
        #   - Using "drawer_top_place_left" as representative placement pose for drawer1
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 3: execute_pick(handle2, ready-pose)
        #   - handle2 → "drawer_middle_handle"
        #   - axis=0 (handle: x-axis)
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)

        # Step 4: execute_place(handle2, drawer1, ready-pose)
        #   - Place into open drawer1, use "drawer_top_place_right"
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    
    except Exception as e:
        print(f"[ERROR] Exception during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
