from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence to 'put two dice in the already open drawer'
    Executes: pick handle1 at ready-pose, place handle1 in drawer1 at ready-pose,
              pick handle2 at ready-pose, place handle2 in drawer1 at ready-pose.
    Only uses skills: execute_pick, execute_place.
    """

    robot = RobotController()

    try:
        # Step 1: Pick up handle1 from ready-pose
        # Approach along the x-axis for handle (axis=0)
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
    except Exception as e:
        print("Error in step 1 (execute_pick handle1):", e)
        return

    try:
        # Step 2: Place handle1 into drawer1 at ready-pose
        # Place along z-axis (objects into drawer), axis=2
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print("Error in step 2 (execute_place handle1):", e)
        return

    try:
        # Step 3: Pick up handle2 from ready-pose
        # Approach along the x-axis for handle (axis=0)
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)
    except Exception as e:
        print("Error in step 3 (execute_pick handle2):", e)
        return

    try:
        # Step 4: Place handle2 into drawer1 at ready-pose
        # Place along z-axis, axis=2
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print("Error in step 4 (execute_place handle2):", e)
        return

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()