from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():

    robot = RobotController()

    try:
        # Step 1: execute_pick handle1 at ready-pose
        # handle1 corresponds to "drawer_top_handle"
        robot.execute_movement(Object["drawer_top_handle"], mode=1, axis=0)
        # Step 2: execute_place handle1 into drawer1 at ready-pose
        # Specification/Mapping: place into the open top drawer (drawer1), at "drawer_top_place_left"
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=0)

        # Step 3: execute_pick handle2 at ready-pose
        # handle2 corresponds to "drawer_middle_handle"
        robot.execute_movement(Object["drawer_middle_handle"], mode=1, axis=0)
        # Step 4: execute_place handle2 into drawer1 at ready-pose
        # Place in the same open top drawer, but on the right
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=0)

        # Optionally return to ready pose at the end if desired:
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()
