from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Pick dice1 at ready-pose (approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=8)  # Go to ready pose before pick, safety
        robot.execute_movement(Object["item1"], mode=1, axis=2)
        robot.execute_movement(mode=8)

        # Step 2: Place dice1 in drawer1 at ready-pose (assume drawer1 opening at "drawer_top_place_left")
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        robot.execute_movement(mode=8)

        # Step 3: Pick dice2 at ready-pose (approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_right"], mode=8)  # Go to ready pose before pick, safety
        robot.execute_movement(Object["trash"], mode=1, axis=2)
        robot.execute_movement(mode=8)

        # Step 4: Place dice2 in drawer1 at ready-pose
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"An error occurred during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()