from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Executes the task: Insert a pair of dice into the drawer that is open.
    According to the provided plan:
        1. execute_pick(dice1, ready-pose)      # Pick up dice1 from floor at ready-pose
        2. execute_place(dice1, drawer1, ready-pose) # Place dice1 into open drawer1 at ready-pose
        3. execute_pick(dice2, ready-pose)      # Pick up dice2 from floor at ready-pose
        4. execute_place(dice2, drawer1, ready-pose) # Place dice2 into open drawer1 at ready-pose
    Skills used: execute_pick (mode 1), execute_place (mode 2)
    """

    robot = RobotController()

    # The axis is 2 for picking/placing general objects like dice (approach from above, z-axis)
    # If a pose is not strictly needed, pass None. Otherwise, pass the correct pose from Object.

    try:
        # Step 1: execute_pick dice1
        robot.execute_movement(Object["item1"], mode=1, axis=2)
        # Step 2: execute_place dice1 into open drawer1 at ready-pose
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Step 3: execute_pick dice2
        robot.execute_movement(Object["item2"], mode=1, axis=2)
        # Step 4: execute_place dice2 into open drawer1 at ready-pose
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)

    except KeyError as e:
        print(f"Object key error: {e}. Please check that all required Object keys are present.")
    except Exception as e:
        print(f"Unexpected error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()