from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle execution sequence for:
    Goal: Store two dice in the open drawer.
    Spec steps:
        1. execute_pick(dice1, ready-pose)
        2. execute_place(dice1, drawer1, ready-pose)
        3. execute_pick(item2, ready-pose)
        4. execute_place(item2, drawer1, ready-pose)
    """
    robot = RobotController()
    # Define pose/object references according to available object list
    # dice1 and item2 are to be picked from 'ready-pose' location and placed into 'drawer1'.
    # Since 'dice1' and 'item2' are not in the Object_list (only item2 is present, dice1 is not),
    # but the skeleton expects Object["item2"], we have to handle the mapping here.
    # Similarly, there's no "drawer1" explicit pose, so we'll use an appropriate placeholder or skip for the 'pose1'.

    # Since the actual Object dictionary will likely have only keys provided in object_names,
    # we must handle cases where dice1 (not in object_names) isn't mapped.
    # For illustrative purposes, let's assume we're controlling the pose via the label "item2" for item2, and
    # for dice1, we'll raise an error message if it's not found.

    # Axis selection: dice and general objects are approached along the z-axis (axis=2), as per instructions.

    # Step 1: Pick dice1 at ready-pose
    try:
        if "dice1" in Object:
            robot.execute_movement(Object["dice1"], mode=1, axis=2)
        else:
            print("Warning: dice1 not found in Object list. Skipping execute_pick for dice1.")
    except Exception as e:
        print(f"Error picking dice1: {e}")

    # Step 2: Place dice1 into drawer1 at ready-pose (target place position for drawer1 in object_names is not provided)
    try:
        # No "drawer1" or its place pose in Object; use a generic placeholder for demonstration.
        if "drawer_top_place_left" in Object:
            robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        else:
            print("Warning: drawer1 place position not found in Object list. Skipping execute_place for dice1.")
    except Exception as e:
        print(f"Error placing dice1 into drawer1: {e}")

    # Step 3: Pick item2 at ready-pose
    try:
        if "item2" in Object:
            robot.execute_movement(Object["item2"], mode=1, axis=2)
        else:
            print("Warning: item2 not found in Object list. Skipping execute_pick for item2.")
    except Exception as e:
        print(f"Error picking item2: {e}")

    # Step 4: Place item2 into drawer1 at ready-pose
    try:
        if "drawer_top_place_right" in Object:
            robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
        else:
            print("Warning: drawer1 place position (right) not found in Object list. Skipping execute_place for item2.")
    except Exception as e:
        print(f"Error placing item2 into drawer1: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()