from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    try:
        # Step 1: Go from robot's current location to dice1's location
        robot.execute_movement(Object["dice1"], mode=7)
        # Step 2: Pick up dice1 (approach along z-axis)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 3: Go from dice1's location to open drawer's location (assume drawer_top_place_left is at open drawer)
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
        # Step 4: Place dice1 into the open drawer (left position, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 5: Go from open drawer's location to dice2's location
        robot.execute_movement(Object["dice2"], mode=7)
        # Step 6: Pick up dice2 (approach along z-axis)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        # Step 7: Go from dice2's location to open drawer's location (assume drawer_top_place_right is at open drawer)
        robot.execute_movement(Object["drawer_top_place_right"], mode=7)
        # Step 8: Place dice2 into the open drawer (right position, approach along z-axis)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()