from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    """
    Oracle sequence for: Insert a pair of dice into the drawer that is open.
    Plan (from specification):
      1. execute_pick(dice1, dice1_location)
      2. execute_place(dice1, open_drawer, open_drawer_location)
      3. execute_pick(dice2, dice2_location)
      4. execute_place(dice2, open_drawer, open_drawer_location)
    Mapping:
      dice1 -> dice1
      dice2 -> dice2
      open_drawer: top drawer (drawer_top_place_left/right)
      dice1_location: Object["dice1"]
      dice2_location: Object["dice2"]
      open_drawer_location: Object["drawer_top_place_left"] or Object["drawer_top_place_right"]
    """
    robot = RobotController()

    try:
        # Step 1: Pick up the first die (dice1) from its location
        robot.execute_movement(Object["dice1"], mode=1, axis=2)

        # Move to ready pose
        robot.execute_movement(mode=8)

        # Step 2: Place the first die into the open drawer (left side)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)

        # Move to ready pose
        robot.execute_movement(mode=8)

        # Step 3: Pick up the second die (dice2) from its location
        robot.execute_movement(Object["dice2"], mode=1, axis=2)

        # Move to ready pose
        robot.execute_movement(mode=8)

        # Step 4: Place the second die into the open drawer (right side)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)

        # Move to ready pose
        robot.execute_movement(mode=8)

    except Exception as e:
        print(f"Error during oracle sequence execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()