from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()
    try:
        # Step 1: Go to dice1 location (if not already there)
        robot.execute_movement(Object["dice1"], mode=7)
        # Step 2: Pick dice1 (axis=2 for general object)
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
        # Step 3: Go to open drawer location (drawer_top_place_left)
        robot.execute_movement(Object["drawer_top_place_left"], mode=7)
        # Step 4: Place dice1 into open drawer (left place)
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
        # Step 5: Go to dice2 location
        robot.execute_movement(Object["dice2"], mode=7)
        # Step 6: Pick dice2 (axis=2 for general object)
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
        # Step 7: Go to open drawer location (drawer_top_place_right)
        robot.execute_movement(Object["drawer_top_place_right"], mode=7)
        # Step 8: Place dice2 into open drawer (right place)
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error during task execution: {e}")

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()