from Object_list import Object
from skill_mapping import RobotController

def Long_horizon_task2_oracle_seq():
    robot = RobotController()

    # Step 1: execute_pick dice1 (axis=2 for general object pick)
    try:
        robot.execute_movement(Object["dice1"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in execute_pick dice1: {e}")

    # Step 2: execute_place dice1 in open drawer (use left place pose, axis=2)
    try:
        robot.execute_movement(Object["drawer_top_place_left"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in execute_place dice1: {e}")

    # Step 3: execute_pick dice2 (axis=2 for general object pick)
    try:
        robot.execute_movement(Object["dice2"], mode=1, axis=2)
    except Exception as e:
        print(f"Error in execute_pick dice2: {e}")

    # Step 4: execute_place dice2 in open drawer (use right place pose, axis=2)
    try:
        robot.execute_movement(Object["drawer_top_place_right"], mode=2, axis=2)
    except Exception as e:
        print(f"Error in execute_place dice2: {e}")

    # Optionally, return to ready pose at the end
    try:
        robot.execute_movement(mode=8)
    except Exception:
        pass

def main():
    Long_horizon_task2_oracle_seq()

if __name__ == "__main__":
    main()